package edu.cmu.cs.cs214.concurrencyframework;

public class PrefixSumsNonconcurrentParallelWorkImpl implements PrefixSums {

	/**
	 * This implementation has an unchecked precondition that the input array
	 * length is a power of 2.
	 */
	@Override
	public void computePrefixSums(long[] a) {
		computeNonSequential(a, 0, a.length);
		//computeRecursive(a, 0, a.length, 1);
	}
	
	public void computeNonSequential(long[] a, final int left, final int right) {
		for (int gap = 1; gap < right; gap *= 2) {
			final int twiceGap = 2*gap;
			for (int i = left+gap-1; i+gap < right; i += twiceGap) {  // this loop is trivially parallelizable
				a[i+gap] = a[i] + a[i+gap];
			}	
		}
		for (int gap = (right-left)/2; gap > 0; gap /= 2) {
			final int twiceGap = 2*gap;
			for (int i = left+gap-1; i+gap < right; i += twiceGap) {  // this loop is trivially parallelizable
				a[i] = a[i] + ((i-gap >= 0) ? a[i-gap] : 0); 
			}
		}
	}
	
	public void computeRecursive(long[] a, final int left, final int right, final int gap) {
		final int twiceGap = 2*gap;
		if (left+twiceGap-1 >= right) {
			return;
		}
		
		for (int i = left+gap-1; i+gap < right; i += twiceGap) {  // this loop is trivially parallelizable
			a[i+gap] = a[i] + a[i+gap];
		}

		computeRecursive(a, left, right, twiceGap);
		
		for (int i = left+gap-1; i+gap < right; i += twiceGap) {  // this loop is trivially parallelizable
			a[i] = a[i] + ((i-gap >= 0) ? a[i-gap] : 0); 
		}
	}

}
